let root

function forceTheme(theme) {
	const style = root.body.style;
	style.setProperty("color-scheme", theme);
}

function setOverrideFromEvent(property, color) {
	console.info("Setting", property, "to", color, ".");
	root.body.style.setProperty(property, color);
}

function unsetOverride(property) {
	console.info("Resetting", property, ".");
	root.body.style.removeProperty(property);
}

window.addEventListener("load", () => {
	root = document.getRootNode()

	const formFill = document.getElementById("form-fill");
	formFill.addEventListener("reset", (event) => unsetOverride("--bluelib-fill-color"));
	const formFillColor = document.getElementById("form-fill-color");
	formFillColor.addEventListener("input", (event) => setOverrideFromEvent("--bluelib-fill-color", `color-mix(in srgb, ${event.target.value} 10%, transparent)`));

	const formRim = document.getElementById("form-rim");
	formRim.addEventListener("reset", (event) => unsetOverride("--bluelib-rim-color"));
	const formRimColor = document.getElementById("form-rim-color");
	formRimColor.addEventListener("input", (event) => setOverrideFromEvent("--bluelib-rim-color", event.target.value));

	const formText = document.getElementById("form-text");
	formText.addEventListener("reset", (event) => unsetOverride("--bluelib-text-color"));
	const formTextColor = document.getElementById("form-text-color");
	formTextColor.addEventListener("input", (event) => setOverrideFromEvent("--bluelib-text-color", event.target.value));

	const formInteractable = document.getElementById("form-interactable");
	formInteractable.addEventListener("reset", (event) => unsetOverride("--bluelib-interactable-color"));
	const formInteractableColor = document.getElementById("form-interactable-color");
	formInteractableColor.addEventListener("input", (event) => setOverrideFromEvent("--bluelib-interactable-color", event.target.value));

	const formInteracting = document.getElementById("form-interacting");
	formInteracting.addEventListener("reset", (event) => unsetOverride("--bluelib-interacting-color"));
	const formInteractingColor = document.getElementById("form-interacting-color");
	formInteractingColor.addEventListener("input", (event) => setOverrideFromEvent("--bluelib-interacting-color", event.target.value));
})